%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: plot_bin_data
%
% Scope:    plot overview figure binned data
%
% Input:    data (structure),
%           data_ch4 (structure),
%           bindata (structure),
%           list of gas names (cell)
%
% Output:   overview figure binned data
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function plot_bin_data(data,data_ch4,bindata,gasnames)

tic;fprintf('Running function plot_bin_data...\n');

plotvars_bin=[2 6 4 12 5 13];
plotvars_n2o=NaN(1,6);
plotvars_ch4=NaN(1,6);

 for i=1:width(plotvars_bin)
      if plotvars_bin(1,i)<12
         plotvars_n2o(1,i)=plotvars_bin(1,i)+1;
         plotvars_ch4(1,i)=NaN; 
      end
      if plotvars_bin(1,i)>11
         plotvars_n2o(1,i)=NaN;
         plotvars_ch4(1,i)=plotvars_bin(1,i)-9; 
      end
 end        

figure;
for i=1:6
    subplot(3,2,i);
    if plotvars_bin(1,i)<12       
        plot(data.all(:,1)-bindata.start_time,data.all(:,plotvars_n2o(1,i)),'LineWidth',1.5,'Color',[0.7 0.7 0.7]); %,'handlevisibility','off');
    end
    if plotvars_bin(1,i)>11       
        plot(data_ch4.all(:,1)-bindata.start_time,data_ch4.all(:,plotvars_ch4(1,i)),'LineWidth',1.5,'Color',[0.7 0.7 0.7]); %,'handlevisibility','off');
    end
    hold on;
    for k=1:width(gasnames)
        scatter(bindata.(gasnames{1,k})(:,1),bindata.(gasnames{1,k})(:,plotvars_bin(1,i)),10);
    end
    grid on;
    box on;
    xlim([0 data.all(end,1)-bindata.start_time]);
    ylabel({sprintf('%s',bindata.varlabels{1,plotvars_bin(1,i)})},'fontsize',12);
    if i==5 || i==6
    xlabel('Time [h]','fontsize',12); end
    if i==1
    title('Overview binned data','fontsize',12); end
    if i==6
        lll=cell(1,width(gasnames));
        for n=1:width(gasnames)
            lll{n} = string(gasnames{1,n}); end
        legend(['raw data',lll],'location','northeast');
    end
end

    x0 = 10;
    y0 = 50;
    ww = 900;
    hh = 700;
    set(gcf,'units','points','position',[x0,y0,ww,hh]);
    set(gcf,'Units','Inches');
    pos = get(gcf,'Position');
    set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3),pos(4)]);
    
time_elapsed=toc; fprintf('plot_bin_data completed (execution time: %1.2f s)\n',time_elapsed);    
    
end

